//
//  OPUnionDatabaseFacade.h
//  ApplicationFrameworks
//
//  Created by Michael Fey on 8/18/15.
//
//

#import "OPDatabase.h"

@interface OPUnionDatabaseFacade : OPDatabase <OPDatabaseReadonlyBasicItemSupport, OPDatabaseReadonlyProfileSupport, OPDatabaseReadonlyCategoriesSupport>

- (instancetype)initWithPrimaryProfile:(id<OPGenericProfile>)primaryProfile;

+ (NSSet *)includedProfileUUIDs;
+ (NSSet *)excludedProfileUUIDs; // UUIDs of all profiles that will be filtered out from All Vaults
+ (void)addProfileUUIDsToExclusion:(NSSet *)profileUUIDsToExclude;
+ (void)removeProfileUUIDsFromExclusion:(NSSet *)profileUUIDsToRemoveFromExclusion;

@end
